function AISMN_WaitUntilBuildingIsBuilt::OnEnter(%this,%obj)
{
	//Is the target a building? If not, we'll set a flag denoting it isn't.
	%tar = GetParameterTarget(%obj);
	if (%tar.isServerObject())
	{
	   if (%tar.isLinkObj() == true && %tar.linkStart == false)
	   {
	      %tar = %tar.getLastLinkObj();
	      SetParameterTarget(%obj, %tar);
	   }
	   
      %component = slgQueryInterface(%tar, $CID_BUILDING); 
      %component.setState($BuildingState::Construction);
      
      %object = GetThisObject(%obj);
      %object.playThread(0, "repair");
      %obj.ignoreHigherPriorityActions(true);
      FaceObject(%obj, %tar);
      %object.mountImage("hammer",2);
      
      // Character now building this building
      %cmpChar = slgQueryInterface(%object, $CID_CHARACTER);
      %cmpChar.setState($CharacterState::Build);
	}
}

function AISMN_WaitUntilBuildingIsBuilt::OnExit(%this,%obj)
{
   %object = GetThisObject(%obj);
   %object.playThread( 0, "root");
   %obj.ignoreHigherPriorityActions(false);
   RestoreCharacterOutfit(%obj);
   
   // Character no longer building
   %cmpChar = slgQueryInterface(%object, $CID_CHARACTER);
   %cmpChar.clearState($CharacterState::Build);
   return;
}

function AISMN_WaitUntilBuildingIsBuilt::Update(%this,%obj)
{
   //If we've reached the PRODUCTION state of the building, exit.
	%tar = GetParameterTarget(%obj);
	%component = slgQueryInterface(%tar, $CID_BUILDING); 
	if(!%component)
   {
      ReturnValue(%obj,0);
      return;
   }
   else if(%component.getState() == $BuildingState::Production)
   {
      ReturnValue(%obj,1);
      return;
   }
	
   ReturnValue(%obj,-1);
   return;
}